VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.3#0"; "comctl32.ocx"
Begin VB.Form FrmMain 
   AutoRedraw      =   -1  'True
   Caption         =   "ProcessViewer-VbSysLib"
   ClientHeight    =   6495
   ClientLeft      =   60
   ClientTop       =   750
   ClientWidth     =   10410
   Icon            =   "FrmMain.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   6495
   ScaleWidth      =   10410
   StartUpPosition =   2  'CenterScreen
   Visible         =   0   'False
   Begin ProcViewer_VbSysLib.ProcInfo ProcInfo 
      Height          =   6255
      Index           =   0
      Left            =   4320
      TabIndex        =   2
      Top             =   120
      Width           =   6015
      _ExtentX        =   10610
      _ExtentY        =   11033
   End
   Begin VB.Timer ProcTimer 
      Enabled         =   0   'False
      Interval        =   1000
      Left            =   4440
      Top             =   0
   End
   Begin ComctlLib.TreeView ProcTree 
      Height          =   6255
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   4095
      _ExtentX        =   7223
      _ExtentY        =   11033
      _Version        =   327682
      HideSelection   =   0   'False
      Indentation     =   576
      LabelEdit       =   1
      LineStyle       =   1
      Style           =   7
      ImageList       =   "ImageList1"
      BorderStyle     =   1
      Appearance      =   0
      BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
         Name            =   "Verdana"
         Size            =   9.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      OLEDropMode     =   1
   End
   Begin VB.PictureBox Picture1 
      Appearance      =   0  'Flat
      AutoRedraw      =   -1  'True
      BackColor       =   &H80000005&
      BorderStyle     =   0  'None
      Enabled         =   0   'False
      ForeColor       =   &H80000008&
      Height          =   240
      Left            =   2160
      ScaleHeight     =   7.758
      ScaleMode       =   0  'User
      ScaleWidth      =   256
      TabIndex        =   1
      Top             =   8400
      Visible         =   0   'False
      Width           =   240
   End
   Begin ComctlLib.ImageList ImageList2 
      Left            =   2760
      Top             =   8640
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      MaskColor       =   -2147483643
      _Version        =   327682
      BeginProperty Images {0713E8C2-850A-101B-AFC0-4210102A8DA7} 
         NumListImages   =   1
         BeginProperty ListImage1 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "FrmMain.frx":5C1A
            Key             =   ""
         EndProperty
      EndProperty
   End
   Begin ComctlLib.ImageList ImageList1 
      Left            =   2160
      Top             =   8880
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      MaskColor       =   -2147483643
      _Version        =   327682
   End
   Begin VB.Menu MnRefresh 
      Caption         =   "Rafraichir"
   End
   Begin VB.Menu MnAbout 
      Caption         =   "A propos..."
   End
   Begin VB.Menu MnProc 
      Caption         =   "Menu"
      Visible         =   0   'False
      Begin VB.Menu MnProcess 
         Caption         =   "Fermer"
         Index           =   0
      End
      Begin VB.Menu MnProcess 
         Caption         =   "Terminer"
         Index           =   1
      End
      Begin VB.Menu MnProcess 
         Caption         =   "Suspendre"
         Index           =   2
      End
      Begin VB.Menu MnProcess 
         Caption         =   "Relancer"
         Index           =   3
      End
   End
End
Attribute VB_Name = "FrmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'   ProcessViewer-VbSysLib
' Visualisateur de processus.
' Copyright (C) 2007 - L'quipe Vb System Library
'
' This library is free software; you can redistribute it and/or
' modify it under the terms of the GNU Lesser General Public
' License as published by the Free Software Foundation; either
' version 2.1 of the License, or (at your option) any later version.
'
' This library is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
' Lesser General Public License for more details.

' You should have received a copy of the GNU Lesser General Public
' License along with this library; if not, write to the Free Software
' Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

' If you want to contact us, you can visit :
' http://vbsystemlibrary.free.fr/
' or send a mail at vbsystemlibrary@free.fr

Option Explicit


Private First       As Boolean
Private PidList()   As Long
Private Xf          As Long
Private Yf          As Long
Private Wp          As WINDOWPLACEMENT


Private Sub Form_Initialize()
    Call InitCommonControls
End Sub

Private Sub Form_Load()
'#If [DEBUG] Then

    VbSysLib.SetPrivilege GetCurrentProcessId, "SeDebugPrivilege", True
    VbSysLib.SetProcessPriority GetCurrentProcessId, &H80

    ProcInfo(0).Attached = True
    RefreshProcTree
    VbSysLib.GetProcessIDList PidList
    DoEvents
    Me.Show
    ProcTimer.Enabled = True
    
End Sub

Private Sub Form_Resize()

    On Error GoTo ErrExit
        
    ProcTree.Height = Me.ScaleHeight - ProcTree.Top - 120
    If ProcInfo(0).Attached = True Then ProcInfo(0).Move (ProcTree.Left * 2) + ProcTree.Width, 120, Me.ScaleWidth - ((ProcTree.Left * 2) + ProcTree.Width) - 120, Me.ScaleHeight - 120
    
ErrExit:
    
End Sub

Private Sub lbLink_Click()
    ShellFile "http://vbsystemlibrary.free.fr/"
End Sub

Private Sub MnAbout_Click()
    frmAbout.Show vbModal
End Sub

Private Sub MnProcess_Click(Index As Integer)
    
    Dim skey   As String
    Dim Knxt    As String
    Dim Pid     As Long
    Dim Exp     As Boolean
    
    skey = GetItemKey("", "Selected")
    If skey = "" Then Exit Sub
    Pid = CLng(Right(skey, Len(skey) - 1))
        
    If Index > 1 Then
        If Index = 2 Then
            VbSysLib.SuspendProcess Pid
        Else
            VbSysLib.ResumeProcess Pid
        End If
    Else
        If Index = 0 Then
            Call VbSysLib.CloseProcess(Pid, 5000, False)
        Else
            Call VbSysLib.KillProcess(Pid)
        End If
    End If

End Sub


Private Sub MnRefresh_Click()

    Dim skey As String
    
    LockWindowUpdate ProcTree.hWnd
    ProcTimer.Enabled = False
    DoEvents
    skey = GetItemKey("", "Selected")
    RefreshProcTree
    SelectItem skey, True
    ProcTimer.Enabled = True
    LockWindowUpdate 0
    
End Sub

Private Sub ProcInfo_Detach(Index As Integer, ByVal bDetach As Boolean)
    
    If bDetach Then
        If Me.WindowState = vbMaximized Then Me.WindowState = vbNormal
        DoEvents
        GetWindowPlacement Me.hWnd, Wp
        Me.Width = (ProcTree.Width + (ProcTree.Left * 2) + 120)
    Else
        SetWindowPlacement Me.hWnd, Wp
    End If
    
End Sub

Private Sub ProcTimer_Timer()

    Dim i           As Long
    Dim PidList2()  As Long
    Dim Proc        As Process
    
    VbSysLib.GetProcessIDList PidList2
    
    If UBound(PidList) <> UBound(PidList2) Then
        For i = 1 To UBound(PidList)
            If IsProcessRunning(PidList(i)) = False Then RemoveItem "P" & PidList(i)
        Next i
        For i = 1 To UBound(PidList2)
            If ProcTimer.Enabled = False Then Exit For
            If ItemExist("P" & PidList2(i)) = 0 Then
                Set Proc = New Process
                Proc.GetProcessByID PidList2(i)
                AddItem Proc
                Set Proc = Nothing
            End If
        Next i
        PidList = PidList2
    End If
    
End Sub

Private Sub ProcTree_NodeClick(ByVal Node As ComctlLib.Node)
        ProcInfo(0).ProcessId = Right(Node.Key, Len(Node.Key) - 1)
End Sub

Private Sub RefreshProcTree()

    Dim i               As Long
    Dim ExplorerKey     As String
    Dim PrcList         As New ListProcesses

    Set ProcTree.ImageList = Nothing
    
    ImageList1.ListImages.Clear
    ImageList1.ListImages.Add 1, , ImageList2.ListImages(1).Picture
    Set ProcTree.ImageList = ImageList1
    ProcTree.Nodes.Clear
    
    PrcList.RefreshList
    
    For i = 1 To PrcList.Count
        AddItem PrcList.Process(i)
        If First = False And ExplorerKey = "" Then
            If UCase(PrcList.Process(i).Name) = "EXPLORER.EXE" Then
                ExplorerKey = "P" & PrcList.Process(i).ID
                ProcInfo(0).ProcessId = PrcList.Process(i).ID
            End If
        End If
    Next i
        
    If First = False Then
        SelectItem ExplorerKey, True
        First = True
    End If
    
    Set PrcList = Nothing
    
End Sub

Private Sub ProcTree_KeyDown(KeyCode As Integer, Shift As Integer)
    If KeyCode = 116 Then MnRefresh_Click
End Sub
Private Function GetImageIndex(FileName As String) As Long
    
    If VbSysLib.FileExists(FileName) = False Then
        GetImageIndex = 1
    Else
        Picture1.Cls
        VbSysLib.PaintFileIcon16 FileName, Picture1.hDC
        GetImageIndex = ImageList1.ListImages.Add(, , Picture1.Image).Index
    End If
    
End Function

Private Sub ProcTree_Mouseup(Button As Integer, Shift As Integer, X As Single, Y As Single)
    If Button = 2 Then
        PopupMenu Me.MnProc
    End If
End Sub

Private Sub AddItem(ByRef Proc As Process)

    Dim skey        As String
    Dim ImageIndex  As Long
        
    skey = "P" & Proc.ParentProcessID
    ImageIndex = GetImageIndex(Proc.FileName)
    
    If ItemExist(skey) = 0 Then
        skey = "P" & Proc.ID
        ProcTree.Nodes.Add , , skey, Proc.Name, ImageIndex
    Else
        ProcTree.Nodes.Add skey, tvwChild, "P" & Proc.ID, Proc.Name, ImageIndex
    End If
    ProcTree.Nodes.Item(skey).Tag = Proc.ID
    
End Sub

Private Sub RemoveItem(skey As String)
    
    Dim Knxt    As String
    Dim i       As Integer
    Dim Pid     As Long
    Dim Exp     As Boolean
        
    LockWindowUpdate ProcTree.hWnd
    
    If skey = GetItemKey("", "Selected") Then
        Knxt = GetItemKey(skey, "Previous")
        If Knxt = "" Then
            Knxt = GetItemKey(skey, "Parent")
            Exp = (Knxt <> "")
        Else
            Exp = ProcTree.Nodes.Item(Knxt).Expanded
        End If
    Else
        Exp = ProcTree.SelectedItem.Expanded
        Knxt = ProcTree.SelectedItem.Key
    End If
    
    If ProcTree.Nodes.Item(skey).Children > 0 Then
        RefreshProcTree
        SelectItem Knxt, True
    Else
        ProcTree.Nodes.Remove (skey)
        SelectItem Knxt, Exp
    End If
    
    LockWindowUpdate 0
    
End Sub

Private Function GetItemKey(skey As String, OptionKey As String) As String
    
    On Error GoTo ErrExit
    
    Select Case OptionKey
        Case "Selected":    GetItemKey = ProcTree.SelectedItem.Key
        Case "Previous":    GetItemKey = ProcTree.Nodes(skey).Previous.Key
        Case "Next":        GetItemKey = ProcTree.Nodes(skey).Next.Key
        Case "Child":       GetItemKey = ProcTree.Nodes(skey).Child.Key
        Case "Parent":      GetItemKey = ProcTree.Nodes(skey).Parent.Key
    End Select
    
ErrExit:

End Function
Private Sub SelectItem(skey As String, Optional Expand As Boolean)

    On Error GoTo ErrSel
    ProcInfo(0).ProcessId = Right(skey, Len(skey) - 1)
    ProcTree.Nodes.Item(skey).EnsureVisible
    ProcTree.SelectedItem = ProcTree.Nodes.Item(skey)
    DoEvents
    If Expand Then ProcTree.SelectedItem.Expanded = True
    
ErrSel:
    
End Sub

Private Function ItemExist(skey As String) As Long
    On Error GoTo NotExist
    ItemExist = ProcTree.Nodes.Item(skey).Index
NotExist:
End Function

