Attribute VB_Name = "modAntiAlias"
'   ProcessViewer-VbSysLib
' Visualisateur de processus.
' Copyright (C) 2007 - L'quipe Vb System Library
'
' This library is free software; you can redistribute it and/or
' modify it under the terms of the GNU Lesser General Public
' License as published by the Free Software Foundation; either
' version 2.1 of the License, or (at your option) any later version.
'
' This library is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
' Lesser General Public License for more details.

' You should have received a copy of the GNU Lesser General Public
' License along with this library; if not, write to the Free Software
' Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

' If you want to contact us, you can visit :
' http://vbsystemlibrary.free.fr/
' or send a mail at vbsystemlibrary@free.fr

Option Explicit

Private Declare Function SetPixel Lib "gdi32" (ByVal hDC As Long, ByVal X As Long, ByVal Y As Long, ByVal crColor As Long) As Long
Private Declare Function GetPixel Lib "gdi32" (ByVal hDC As Long, ByVal X As Long, ByVal Y As Long) As Long
Private Declare Sub CopyMemory Lib "kernel32" Alias "RtlMoveMemory" (pDst As Any, pSrc As Any, ByVal ByteLen As Long)
Private Type RGBColor
    R As Byte
    G As Byte
    B As Byte
End Type

' Tout cela en pixels
Public Function AntiAliasPoint(hDC As Long, X As Single, Y As Single, Color As Long)
    ' Le carr de points en dessous
    Dim Points(2, 2) As RGBColor
    Dim NewColor As RGBColor
    Dim Aire As Single
    NewColor = GetRGB(Color)
    ' On rcupre leurs couleurs
    Points(1, 1) = GetRGB(GetPixel(hDC, Int(X), Int(Y)))
    Points(2, 1) = GetRGB(GetPixel(hDC, Int(X) + 1, Int(Y)))
    Points(1, 2) = GetRGB(GetPixel(hDC, Int(X), Int(Y) + 1))
    Points(2, 2) = GetRGB(GetPixel(hDC, Int(X) + 1, Int(Y) + 1))
    ' Calcul de l'air prsente dans le carr en haut  gauche
    Aire = (1 - (X - Int(X))) * (1 - (Y - Int(Y)))
    SetPixel hDC, Int(X), Int(Y), Composante(NewColor, Aire, Points(1, 1), 1 - Aire)
    ' Calcul de l'air prsente dans le carr en haut  droite
    Aire = (X - Int(X)) * (1 - (Y - Int(Y)))
    SetPixel hDC, Int(X) + 1, Int(Y), Composante(NewColor, Aire, Points(1, 1), 1 - Aire)
    ' Calcul de l'air prsente dans le carr en bas  gauche
    Aire = (1 - (X - Int(X))) * (Y - Int(Y))
    SetPixel hDC, Int(X), Int(Y) + 1, Composante(NewColor, Aire, Points(1, 2), 1 - Aire)
    ' Calcul de l'air prsente dans le carr en bas  droite
    Aire = (X - Int(X)) * (Y - Int(Y))
    SetPixel hDC, Int(X) + 1, Int(Y) + 1, Composante(NewColor, Aire, Points(2, 2), 1 - Aire)
End Function

' trace une ligne antialias
Public Function AntiAliasLine(ByVal hDC As Long, ByVal X1 As Single, ByVal Y1 As Single, ByVal X2 As Single, ByVal Y2 As Single, ByVal Color As Long)
    Dim A As Single
    Dim B As Single
    Dim X As Single
    Dim Y As Single
    ' Equation de la droite :
    ' Y = A* X + B
    ' Calcul de A et de B
    If X2 = X1 Then
        A = (Y2 - Y1) / 1
    Else
        A = (Y2 - Y1) / (X2 - X1)
    End If
    B = Y1 - (A * X1)
    If Abs(A) <= 1 Then
        If X1 <= X2 Then
            For X = X1 To X2 - 1
                Y = A * X + B
                AntiAliasPoint hDC, X, Y, Color
            Next X
        Else
            For X = X2 + 1 To X1
                Y = A * X + B
                AntiAliasPoint hDC, X, Y, Color
            Next X
        End If
    Else
        If Y1 <= Y2 Then
            For Y = Y1 To Y2 - 1
                X = (Y - B) / A
                AntiAliasPoint hDC, X, Y, Color
            Next Y
        Else
            For Y = Y2 + 1 To Y1
                X = (Y - B) / A
                AntiAliasPoint hDC, X, Y, Color
            Next Y
        End If
    End If
End Function

Private Function Composante(Couleur1 As RGBColor, Coeff1 As Single, Couleur2 As RGBColor, Coeff2 As Single) As Long
    Dim Sortie As RGBColor
    Sortie.R = Couleur1.R * Coeff1 + Couleur2.R * Coeff2
    Sortie.G = Couleur1.G * Coeff1 + Couleur2.G * Coeff2
    Sortie.B = Couleur1.B * Coeff1 + Couleur2.B * Coeff2
    Composante = RGB(Sortie.R, Sortie.G, Sortie.B)
End Function

Private Function GetRGB(ByVal Color As Long) As RGBColor
    CopyMemory GetRGB, Color, 3
End Function

