VERSION 5.00
Begin VB.UserControl Graph 
   AutoRedraw      =   -1  'True
   ClientHeight    =   3600
   ClientLeft      =   0
   ClientTop       =   0
   ClientWidth     =   4800
   ScaleHeight     =   240
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   320
   ToolboxBitmap   =   "Graph.ctx":0000
End
Attribute VB_Name = "Graph"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'   ProcessViewer-VbSysLib
' Visualisateur de processus.
' Copyright (C) 2007 - L'quipe Vb System Library
'
' This library is free software; you can redistribute it and/or
' modify it under the terms of the GNU Lesser General Public
' License as published by the Free Software Foundation; either
' version 2.1 of the License, or (at your option) any later version.
'
' This library is distributed in the hope that it will be useful,
' but WITHOUT ANY WARRANTY; without even the implied warranty of
' MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
' Lesser General Public License for more details.

' You should have received a copy of the GNU Lesser General Public
' License along with this library; if not, write to the Free Software
' Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA

' If you want to contact us, you can visit :
' http://vbsystemlibrary.free.fr/
' or send a mail at vbsystemlibrary@free.fr

Option Explicit

'Cette fonction dessine un trait depuis la position courante jusqu' un point donn.
'hdc est un pointeur vers un contexte de priphrique.
'x et y indiquent la position du point d'arrive du trait  dessiner.
'Pour modifier la position du point d'insertion courant, utiliser la fonction MoveToEx.
Private Declare Function LineTo Lib "gdi32" (ByVal hDC As Long, ByVal X As Long, ByVal Y As Long) As Long
Private Declare Function MoveToEx Lib "gdi32" (ByVal hDC As Long, ByVal X As Long, ByVal Y As Long, lpPoint As POINTAPI) As Long
Private Type POINTAPI
    X As Long
    Y As Long
End Type

' Les valeurs du graphique
Dim Values() As Long
' La valeur la plus rcente est repre par son index
Dim FirstValue As Long
' Exemple :
' dernire valeur ajoute
'           \ /
' |3|4|5|6|7|8|1|2|
'             / \
'          FirstValue
' Les limites des valeurs
Dim lMin As Long, lMax As Long

' Les valeurs d'apparence
Dim IsLegend    As Boolean
Dim sUnit       As String
Dim IsAntiAlias As Boolean
Dim IsSmoothing As Boolean
Dim lForeColor  As Long
Dim lTextColor  As Long
Dim sTitle      As String
Dim bDraw       As Boolean

' Ajoute une valeur
Public Sub AddValue(lValue As Long)
    If lValue >= lMin And lValue <= lMax Then
        ' Ajoute la valeur en crasant la plus ancienne
        Values(FirstValue) = lValue
        ' Dcale l'index
        FirstValue = FirstValue + 1
        If FirstValue > UBound(Values) Then FirstValue = 1
        ' Rafraichit
        If bDraw = True Then Refresh
    End If
End Sub

' Rafraichit le graphique
Public Sub Refresh()
    ' Les coeffs pour s'adapter  l'chelle
    Dim lXCoeff     As Single
    Dim lYCoeff     As Single
    Dim lStep       As Long
    Dim T           As Long
    Dim X           As Single
    Dim Y           As Single
    Dim lPoint      As POINTAPI
    Dim tempOldY    As Single
    Dim OldY        As Single
    Dim OldX        As Single
    Dim tempVar     As Single
    Dim textCaption As String
    Dim textTop     As Long
    Dim textHeight  As Long
    tempVar = Exp(1)
    ' Efface tout
    UserControl.Cls
    If NBValues <= 1 Or lMax <= lMin Then Exit Sub
    ' Affiche le titre
    UserControl.CurrentX = 0
    UserControl.CurrentY = 0
    UserControl.ForeColor = lTextColor
    UserControl.Print sTitle
    ' Calcule l'espace entre 2 points
    ' Il faut qu'il y ait au minimum 1 pixel d'espace entre 2 points (en largeur)
    lStep = 0
    Do
        lStep = lStep + 1
        lXCoeff = UserControl.ScaleWidth / ((UBound(Values) - 1) / lStep)
    Loop Until lXCoeff >= 1
    ' En pixels/units
    lYCoeff = UserControl.ScaleHeight / (lMax - lMin)
    ' Affiche la lgende
    If IsLegend Then
        ' Charge le nombre d'lment ncessaires
        ' il faut un minimum de 100 pixels d'espace entre chaque lgende
        Dim NbLegends As Integer
        Dim NbDigits As Integer
        NbLegends = (UserControl.ScaleHeight \ 100) + 1
        ' Les positionne
        For T = 0 To NbLegends - 1
            textHeight = UserControl.textHeight("Azerty")
            textTop = UserControl.ScaleHeight - T * (UserControl.ScaleHeight / NbLegends) - textHeight
            UserControl.CurrentY = textTop
            ' On veut une prcision de 3 chiffres
            NbDigits = 3 - Int(Log(lMax - lMin))
            If NbDigits < 0 Then NbDigits = 0
            textCaption = Str(Round(((UserControl.ScaleHeight - textHeight - textTop - lMin * lYCoeff) / lYCoeff), NbDigits)) + " " + sUnit
            UserControl.ForeColor = lTextColor
            UserControl.Print textCaption
        Next T
    End If
    ' Commence le dessin du graphe
    UserControl.ForeColor = lForeColor
    OldY = UserControl.ScaleHeight - (Values(FirstValue) - lMin) * lYCoeff
    OldX = 0
    MoveToEx UserControl.hDC, 0, OldY, lPoint
    For T = FirstValue + 1 To UBound(Values) Step lStep
        lPoint.X = (T - FirstValue) * lXCoeff
        lPoint.Y = UserControl.ScaleHeight - (Values(T) - lMin) * lYCoeff
        tempOldY = OldY
        If IsSmoothing = True Then
            ' Trace la fonction qui lisse le passage entre 2 points
            For X = 0 To lXCoeff
                Y = lPoint.Y - ((lPoint.Y - OldY) / (1 + Exp(4 * (X / lXCoeff) * tempVar - 2 * tempVar)))
                If IsAntiAlias = False Then
                    LineTo UserControl.hDC, lPoint.X + X - lXCoeff, Y
                Else
                    AntiAliasLine UserControl.hDC, Int(lPoint.X + X - lXCoeff - 1), Int(tempOldY), Int(lPoint.X + X - lXCoeff), Int(Y), lForeColor
                End If
                tempOldY = Y
            Next X
            OldY = lPoint.Y
        Else
            ' Trace une simple droite
            If IsAntiAlias = False Then
                LineTo UserControl.hDC, lPoint.X, lPoint.Y
            Else
                AntiAliasLine UserControl.hDC, Int(OldX), Int(OldY), Int(lPoint.X), Int(lPoint.Y), lForeColor
            End If
            OldX = lPoint.X
            OldY = lPoint.Y
        End If
    Next T
    For T = LBound(Values) To FirstValue - 1 Step lStep
        lPoint.X = (T + UBound(Values) - FirstValue) * lXCoeff
        lPoint.Y = UserControl.ScaleHeight - (Values(T) - lMin) * lYCoeff
        If IsSmoothing = True Then
            ' Trace la fonction qui lisse le passage entre 2 points
            For X = 0 To lXCoeff
                Y = lPoint.Y - ((lPoint.Y - OldY) / (1 + Exp(4 * (X / lXCoeff) * tempVar - 2 * tempVar)))
                If IsAntiAlias = False Then
                    LineTo UserControl.hDC, lPoint.X + X - lXCoeff, Y
                Else
                    AntiAliasLine UserControl.hDC, Int(lPoint.X + X - lXCoeff - 1), Int(tempOldY), Int(lPoint.X + X - lXCoeff), Int(Y), lForeColor
                End If
                tempOldY = Y
            Next X
            OldY = lPoint.Y
        Else
            ' Trace une simple droite
            If IsAntiAlias = False Then
                LineTo UserControl.hDC, lPoint.X, lPoint.Y
            Else
                AntiAliasLine UserControl.hDC, Int(OldX), Int(OldY), Int(lPoint.X), Int(lPoint.Y), lForeColor
            End If
            OldX = lPoint.X
            OldY = lPoint.Y
        End If
    Next T
End Sub

' Efface toutes les donnes
Public Sub Clear()
    Dim lNbValues As Long
    lNbValues = UBound(Values)
    Erase Values
    ReDim Values(1 To lNbValues) As Long
    UserControl.Cls
End Sub

Private Sub UserControl_Initialize()
    ReDim Values(1 To 1) As Long
    FirstValue = 1
    bDraw = True
End Sub
Private Sub UserControl_Resize()
    Refresh
End Sub

Public Property Get Max() As Long
    Max = lMax
End Property
Public Property Let Max(ByVal lNewValue As Long)
    lMax = lNewValue
    PropertyChanged "Max"
End Property

Public Property Get Min() As Long
    Min = lMin
End Property
Public Property Let Min(ByVal lNewValue As Long)
    lMin = lNewValue
    PropertyChanged "Min"
End Property

' Attention, modifier le nombre de valeurs efface les donnes prcdentes
Public Property Get NBValues() As Long
    NBValues = UBound(Values)
End Property
Public Property Let NBValues(ByVal lNewValue As Long)
    If lNewValue < 1 Then lNewValue = 1
    ReDim Values(1 To lNewValue) As Long
    PropertyChanged "NBValues"
End Property

Public Property Get BackColor() As OLE_COLOR
    BackColor = UserControl.BackColor
End Property
Public Property Let BackColor(ByVal lNewValue As OLE_COLOR)
    UserControl.BackColor = lNewValue
    PropertyChanged "BackColor"
    Refresh
End Property

Public Property Get ForeColor() As OLE_COLOR
    ForeColor = lForeColor
End Property
Public Property Let ForeColor(ByVal lNewValue As OLE_COLOR)
    lForeColor = lNewValue
    PropertyChanged "ForeColor"
    Refresh
End Property

Public Property Get TextColor() As OLE_COLOR
    TextColor = lTextColor
End Property
Public Property Let TextColor(ByVal lNewValue As OLE_COLOR)
    lTextColor = lNewValue
    PropertyChanged "TextColor"
    Refresh
End Property

Public Property Get Border() As Boolean
    Border = CBool(UserControl.BorderStyle)
End Property
Public Property Let Border(ByVal bNewValue As Boolean)
    UserControl.BorderStyle = IIf(bNewValue, 1, 0)
    PropertyChanged "Border"
End Property

Public Property Get Title() As String
    Title = sTitle
End Property
Public Property Let Title(ByVal sNewValue As String)
    sTitle = sNewValue
    PropertyChanged "Title"
    Refresh
End Property

Public Property Get Legend() As Boolean
    Legend = IsLegend
End Property
Public Property Let Legend(ByVal bNewValue As Boolean)
    IsLegend = bNewValue
    PropertyChanged "Legend"
    Refresh
End Property

Public Property Get Unit() As String
    Unit = sUnit
End Property
Public Property Let Unit(ByVal sNewValue As String)
    sUnit = sNewValue
    PropertyChanged "Unit"
    Refresh
End Property

' Active ou non l'antialias
Public Property Get AntiAlias() As Boolean
    AntiAlias = IsAntiAlias
End Property
Public Property Let AntiAlias(ByVal bNewValue As Boolean)
    IsAntiAlias = bNewValue
    PropertyChanged "AntiAlias"
    Refresh
End Property

' Active ou non le lissage de la courbe
Public Property Get Smooth() As Boolean
    Smooth = IsSmoothing
End Property
Public Property Let Smooth(ByVal bNewValue As Boolean)
    IsSmoothing = bNewValue
    PropertyChanged "Smooth"
    Refresh
End Property

' Active ou non si la courbe est dessine
Public Property Get DrawGraph() As Boolean
    DrawGraph = bDraw
End Property
Public Property Let DrawGraph(ByVal bNewValue As Boolean)
    bDraw = bNewValue
End Property

'Permet de sauvegarder les proprits du controle (sinon elles s'effacent  chaque fois)
Private Sub UserControl_ReadProperties(PropBag As PropertyBag)
    Dim T As Long
    Let lMax = PropBag.ReadProperty("Max", 100)
    Let lMin = PropBag.ReadProperty("Min", 0)
    Let NBValues = PropBag.ReadProperty("NBValues", 100)
    Let UserControl.BackColor = PropBag.ReadProperty("BackColor", vbWhite)
    Let lForeColor = PropBag.ReadProperty("ForeColor", vbBlack)
    Let lTextColor = PropBag.ReadProperty("TextColor", vbBlack)
    Let UserControl.BorderStyle = PropBag.ReadProperty("Border", False)
    Let sTitle = PropBag.ReadProperty("Title", "")
    Let IsLegend = PropBag.ReadProperty("Legend", True)
    Let sUnit = PropBag.ReadProperty("Unit", "")
    Let IsAntiAlias = PropBag.ReadProperty("AntiAlias", False)
    Let IsSmoothing = PropBag.ReadProperty("Smooth", True)
    ' Applique les changements
    Refresh
End Sub
Private Sub UserControl_WriteProperties(PropBag As PropertyBag)
    Call PropBag.WriteProperty("Max", lMax, 100)
    Call PropBag.WriteProperty("Min", lMin, 0)
    Call PropBag.WriteProperty("NBValues", NBValues, 100)
    Call PropBag.WriteProperty("BackColor", UserControl.BackColor, vbWhite)
    Call PropBag.WriteProperty("ForeColor", lForeColor, vbBlack)
    Call PropBag.WriteProperty("TextColor", lTextColor, vbBlack)
    Call PropBag.WriteProperty("Border", UserControl.BorderStyle)
    Call PropBag.WriteProperty("Title", sTitle)
    Call PropBag.WriteProperty("Legend", IsLegend, False)
    Call PropBag.WriteProperty("AntiAlias", IsAntiAlias, False)
    Call PropBag.WriteProperty("Smooth", IsSmoothing, True)
End Sub
